<?php

namespace App\modules\Mis\Models;

use App\modules\Mis\database\factories\BikrKstAbteilungFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class BikrKstAbteilung extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'bikr_kst_abteilungen';
    protected $guarded = ['id'];
    protected $hidden = ['created_at', 'updated_at', 'deleted_at', 'bikr_kst_bereiche_id'];

    /**
     * Create a new factory instance for the model.
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return BikrKstAbteilungFactory::new();
    }

    public function bereich(): BelongsTo
    {
        return $this->belongsTo(BikrKstBereich::class, 'bikr_kst_bereiche_id');
    }

    public function getTypeBezeichnungAttribute()
    {
        return $this->type == 'h' ? 'Hilfskostenstelle (h)' : 'Kostenstelle (k)';
    }

    /**
     * @return array
     * $columns = Schema::getColumns($this->table)) : array
     */
    public static function indexColumnSetting(): array
    {
        return [
            'meta' => [],
            'header' => [
                'id' => 'ID',
                'abteilung' => 'Abteilung',
                'bezeichnung' => 'Bezeichnung',
                'beschreibung' => 'Beschreibung',
                'type' => 'Typ',
                'personal' => 'Personal',
            ],
            'columns' => [
                'id' => ['type' => 'number'],
                'abteilung' => ['type' => 'string', 'fnedit' => '/mis/klr/stammdaten/abteilung'],
                'bezeichnung' => ['type' => 'string'],
                'beschreibung' => ['type' => 'string'],
                'type' => ['type' => 'string'],
                'personal' => ['type' => 'number'],
            ],
        ];
    }
}
