<?php

namespace App\modules\Mis\Models;

use App\modules\Mis\database\factories\BikrParameterFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BikrBilanz extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'bikr_bilanzen';
    protected $guarded = ['id'];

    /**
     * Create a new factory instance for the model.
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return BikrBilanzFactory::new();
    }






    /**
     * Columns Setup for different visualisations
     */

    public static function indexColumnSettings(): array
    {
        return [
            'header' => [
                'id' => 'ID',
                'jahr' => 'Jahr',
                'lohn' => 'Lohn',
                'sozialabgaben' => 'Sozialabgaben',
                'abschreibungen' => 'Abschreibungen',
                'aufwaende' => 'Aufwände',
                'zinsen' => 'Zinsen',
                'vorraete' => 'Vorräte',
                'personalzahl' => 'Personal',
            ],
            'columns' => [
                'id' => ['type' => 'number'],
                'jahr' => ['type' => 'year', 'fnedit' => '/mis/klr/stammdaten/bilanz'],
                'lohn' => ['type' => 'currency'],
                'sozialabgaben' => ['type' => 'currency'],
                'abschreibungen' => ['type' => 'currency'],
                'aufwaende' => ['type' => 'currency'],
                'zinsen' => ['type' => 'currency'],
                'vorraete' => ['type' => 'currency'],
                'personalzahl' => ['type' => 'number'],
            ],
        ];
    }

    public static function createColumnSettings():array
    {
        return [
            'header' => [
                'name' => 'Name',
                'bezeichnung' => 'Bez',
                'value_numeric' => 'Wert',
                'value_string' => 'Text',
            ],
            'columns' => [
                'name' => ['type' => 'string', 'fnedit' => '/mis/klr/stammdaten/parameter'],
                'bezeichnung' => ['type' => 'string'],
                'value_numeric' => ['type' => 'float'],
                'value_string' => ['type' => 'string'],
            ],
        ];
    }


}
