<?php

namespace App\modules\Mis\Controllers;

use App\Http\Controllers\Controller;
use App\modules\Core\Services\OraApiService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Validation\ValidationException;

class StatVerkaufController extends Controller
{
    /**
     * Searchmask for rgjournal
     * @return void
     * @throws \Illuminate\Http\Client\ConnectionException
     */
    public function rgjournal()
    {
        return view('mis::stat.vk.rgjournal.search');
    }

    public function rgjournal_request(Request $request, OraApiService $apiService)
    {
        $request->validate([
            'date--re-datum--from' => 'nullable|date_format:d.m.Y',
            'date--re-datum--to' => 'nullable|date_format:d.m.Y',
            'number--renr' => 'nullable|integer',
            'number--kdnr' => 'nullable|integer'
        ]);

        $response = $apiService->rechnungsjournal($request);
        $data = $response['data'] ?? [];

        $tableDef = [
            'header' => [
                'ANR' => 'Auftrag',
                'A_ART' => 'Auftrags-Art',
                'RENR' => 'RGNR',
                'RECHNUNG_ART' => 'RG-Art',
                'KDNR' => 'KDNR',
                'RE_DATUM' => 'RE-Datum',
                'RNAME1' => 'Kundenname',
                'STEUER_SATZ' => 'Steuersatz',
                'STEUER_BETRAG' => 'Steuerbetrag',
                'REBETNETTO' => 'Netto',
                'C_RG_BRUTTO' => 'RG Brutto',
                'C_RABATT' => 'RG Rabatt',
                //'REBETBRUTTO' => 'Brutto',
                //'RABATTBRUTTO' => 'Rabattbasis',
                'VERSAND' => 'Versand',
            ],
            'columns' => [
                'ANR' => ['type' => 'integer'],
                'A_ART' => ['type' => 'string'],
                'RENR' => ['type' => 'integer'],
                'RECHNUNG_ART' => ['type' => 'string', 'orange_on' => 'GU'],
                'KDNR' => ['type' => 'integer'],
                'RE_DATUM' => ['type' => 'date'],
                'RNAME1' => ['type' => 'string', 'fnlink' => '/mis/stat/vk/rgjournal_kd', 'fnlinkid' => 'KDNR'],
                'STEUER_SATZ' => ['type' => 'percent'],
                'STEUER_BETRAG' => ['type' => 'currency'],
                'REBETNETTO' => ['type' => 'currency'],
                'C_RG_BRUTTO' => ['type' => 'currency'],
                'C_RABATT' => ['type' => 'currency'],
                #'REBETBRUTTO' => ['type' => 'currency'],
                #'RABATTBRUTTO' => ['type' => 'currency'],
                'VERSAND' => ['type' => 'currency'],
            ],
            'meta' => [
                'keyname' => 'renr'
            ],
            'footer' => [
                'STEUER_BETRAG' => ['fn' => 'sum'],
                'REBETNETTO' => ['fn' => 'sum'],
                'C_RG_BRUTTO' => ['fn' => 'sum'],
                'C_RABATT' => ['fn' => 'sum'],
                'VERSAND' => ['fn' => 'sum'],
            ]
        ];
        return view('mis::stat.vk.rgjournal.list', compact('data', 'tableDef', 'request'));
    }

    public function rgjournal_kd($kdnr, Request $request, OraApiService $apiService)
    {
//        $request->validate([
//            'date--re-datum--from' => 'nullable|date_format:d.m.Y',
//            'date--re-datum--to' => 'nullable|date_format:d.m.Y',
//            'number--renr' => 'nullable|integer',
//            'number--kdnr' => 'nullable|integer'
//        ]);
//
        $request['_method'] = 'GET';
        $request['number--kdnr'] = $kdnr;
        $request['date--re-datum--from'] = date('d.m.Y', strtotime('1.1.'.date('Y')));
        $request['date--re-datum--to'] = date('d.m.Y', strtotime('31.12.'.date('Y')));

        $response = $apiService->rechnungsjournal($request);
        $data = $response['data'];

        $tableDef = [
            'header' => [
                'ANR' => 'Auftrag',
                'A_ART' => 'Auftrags-Art',
                'RENR' => 'RGNR',
                'RECHNUNG_ART' => 'RG-Art',
                'KDNR' => 'KDNR',
                'RE_DATUM' => 'RE-Datum',
                'RNAME1' => 'Kundenname',
                'STEUER_SATZ' => 'Steuersatz',
                'STEUER_BETRAG' => 'Steuerbetrag',
                'REBETNETTO' => 'Netto',
                'C_RG_BRUTTO' => 'RG Brutto',
                'C_RABATT' => 'RG Rabatt',
                //'REBETBRUTTO' => 'Brutto',
                //'RABATTBRUTTO' => 'Rabattbasis',
                'VERSAND' => 'Versand',
            ],
            'columns' => [
                'ANR' => ['type' => 'integer'],
                'A_ART' => ['type' => 'string'],
                'RENR' => ['type' => 'integer'],
                'RECHNUNG_ART' => ['type' => 'string', 'orange_on' => 'GU'],
                'KDNR' => ['type' => 'integer'],
                'RE_DATUM' => ['type' => 'date'],
                'RNAME1' => ['type' => 'string'],
                'STEUER_SATZ' => ['type' => 'percent'],
                'STEUER_BETRAG' => ['type' => 'currency'],
                'REBETNETTO' => ['type' => 'currency'],
                'C_RG_BRUTTO' => ['type' => 'currency'],
                'C_RABATT' => ['type' => 'currency'],
                #'REBETBRUTTO' => ['type' => 'currency'],
                #'RABATTBRUTTO' => ['type' => 'currency'],
                'VERSAND' => ['type' => 'currency'],
            ],
            'meta' => [
                'keyname' => 'renr'
            ],
            'footer' => [
                'STEUER_BETRAG' => ['fn' => 'sum'],
                'REBETNETTO' => ['fn' => 'sum'],
                'C_RG_BRUTTO' => ['fn' => 'sum'],
                'C_RABATT' => ['fn' => 'sum'],
                'VERSAND' => ['fn' => 'sum'],
            ]
        ];
        return view('mis::stat.vk.rgjournal.list', compact('data', 'tableDef', 'request'));
    }


    public function kunden()
    {
        return view('mis::stat.vk.kunden.search');
    }

    public function kunden_request(Request $request)
    {
        // date is prior to month. Patch request entities.
        if ($request->has('date--auftrag-datum') && !empty($request->get('date--auftrag-datum'))) {
            $request->request->remove('date--monat');
        } elseif ($request->has('date--monat') && !empty($request->get('date--monat'))) {
            list($m,$y) = explode('.', $request->get('date--monat'));
            Carbon::setLocale('de');
            $date = Carbon::createFromDate($y, $m, 1);
            $start = $date->startOfMonth()->format('Y-m-d');
            $end = $date->endOfMonth()->format('Y-m-d');
            $request->request->add(['date--auftrag-datum' => $start.' - '. $end]);
            $request->request->remove('date--monat');
        }

        // prevent empty searchmask submit
        $anyInput = false;
        foreach ($request->all() as $name => $value) {
            if (\Str::startsWith($name, 'option--') || \Str::startsWith($name, '_')) { continue; }
            if ($value !== null && $value !== '') {
                $anyInput = true;
            }
        }
        if ($anyInput == false) {
            throw ValidationException::withMessages(['general' => 'Mindestens eine Eingabe erforderlich']);
        }

        // from options to a_status
        $querytype = $request->get('option--querytype');
        $request->request->add(['slist--a-art' => 'KA,LI,SA']);

        switch ($querytype) {
            case 'auftragseingang':
                $request->request->add(['nlist--a-status' => '1000,1001']); // in Arbeit/gedruckt
            break;
                break;
            case 'auftragsbestand':
                $request->request->add(['nlist--a-status' => '7100,7110']); // AN -> AUF/gedruckt
                break;
            case 'geliefert':
                $request->request->add(['nlist--a-status' => '7200,7210']); // LS Komplett/gerduckt
                break;
            case 'berechnet':
                $request->request->add(['nlist--a-status' => '8000,8100']); // Teil-/EndRG
                break;
        }

        $select = $request->get('option--list');
        if (isset($select) && !empty($select)) {
            switch ($select[0]) {
                case 'sum':
                    return $this->kunden_sumarisch($request);
                    break;
                case 'pg':
                    return $this->kunden_pg($request);
                    break;
                case 'art':
                    $kundenRequest = 'customer_orders_art';
                    return $this->kunden_sumarisch($request, $kundenRequest);
                    break;
                case 'artmng':
                    $kundenRequest = 'customer_orders_artmng';
                    return $this->kunden_sumarisch($request, $kundenRequest);
                    break;
            }
        }

    }

    protected function kunden_sumarisch(Request $request)
    {
        $apiService = new OraApiService();
        $response = $apiService->customer_orders($request);
        $data = $response['data'] ?? [];
        $orasql = $response['params']['sql'] ?? [];

        $tableDef = [
            'header' => [
                'KDNR' => 'KDNR',
                'NAME1' => 'Kundenname',
                'LANDCODE' => 'Land',
                'RABATTBRUTTO' => 'Wert',
            ],
            'columns' => [
                'KDNR' => ['type' => 'integer'],
                'NAME1' => ['type' => 'string'],
                'LANDCODE' => ['type' => 'string'],
                'RABATTBRUTTO' => ['type' => 'currency'],
            ],
            'meta' => [
                'keyname' => 'renr'
            ],
            'footer' => [
                'RABATTBRUTTO' => ['fn' => 'sum'],
            ]
        ];

        return view('mis::stat.vk.kunden.orders', compact('orasql', 'data', 'tableDef', 'request'));
    }

    protected function kunden_pg(Request $request)
    {
        $apiService = new OraApiService();
        $response = $apiService->customer_orders_pg($request);
        $data = $response['data'] ?? [];
        $orasql = $response['params']['sql'] ?? [];

        $tableDef = [
            'header' => [
                'KDNR' => 'KDNR',
                'NAME1' => 'Kundenname',
                'LANDCODE' => 'Land',
                'PRODUKT_GR' => 'PG',
                'GR_BEZ' => 'PG-Bez',
                'LIEFERMENGE' => 'Menge',
                'POS_WERT_BRUTTO' => 'Wert',
            ],
            'columns' => [
                'KDNR' => ['type' => 'integer', 'group' => 'KDNR,NAME1,LANDCODE', '_group_replace' => 'GR_BEZ', 'groupsum' => ['POS_WERT_BRUTTO']],
                'NAME1' => ['type' => 'string'],
                'LANDCODE' => ['type' => 'string'],
                'PRODUKT_GR' => ['type' => 'number'],
                'GR_BEZ' => ['type' => 'string'],
                'LIEFERMENGE' => ['type' => 'number'],
                'POS_WERT_BRUTTO' => ['type' => 'currency'],
            ],
            'meta' => [
                'keyname' => 'renr'
            ],
            'footer' => [
//                'REBETNETTO' => ['fn' => 'sum'],
                'POS_WERT_BRUTTO' => ['fn' => 'sum'],
            ]
        ];

        return view('mis::stat.vk.kunden.orders', compact('orasql', 'data', 'tableDef', 'request'));
    }
}

