<?php

namespace App\modules\Mis\Controllers;

use App\Http\Controllers\Controller;
use App\modules\Core\Services\OraApiService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class StatEinkaufController extends Controller
{
    public function lieferant()
    {
        return view('mis::stat.ek.lieferant.search');
    }

    public function lieferant_request(Request $request, OraApiService $apiService)
    {
        // date is prior to month. Patch request entities.
        if ($request->has('date--auftrag-datum') && !empty($request->get('date--auftrag-datum'))) {
            $request->request->remove('date--monat');
        } elseif ($request->has('date--monat') && !empty($request->get('date--monat'))) {
            list($m,$y) = explode('.', $request->get('date--monat'));
            Carbon::setLocale('de');
            $date = Carbon::createFromDate($y, $m, 1);
            $start = $date->startOfMonth()->format('Y-m-d');
            $end = $date->endOfMonth()->format('Y-m-d');
            $request->request->add(['date--auftrag-datum' => $start.' - '. $end]);
            $request->request->remove('date--monat');
        }

        // prevent empty searchmask submit
        $anyInput = false;
        foreach ($request->all() as $name => $value) {
            if (\Str::startsWith($name, 'option--') || \Str::startsWith($name, '_')) { continue; }
            if ($value !== null && $value !== '') {
                $anyInput = true;
            }
        }
        if ($anyInput == false) {
            throw ValidationException::withMessages(['general' => 'Mindestens eine Eingabe erforderlich']);
        }

        // from options to a_status
        $querytype = $request->get('option--querytype');

        $select = $request->get('option--list');
        $request->request->add(['slist--a-art' => 'BE']);
                if (isset($select['rahmen'])) {
            $request['slist--a-art'] .= ',RV';
        }

        switch ($querytype) {
            case 'offene':
                $lieferantRequest = 'supplier_openorders';
                $request->request->add(['nlist--a-status' => '2700,2710,2800,2930,2950']); // bestellt

                break;
            case 'outdated':
                break;
            case 'teilbeliefert':
                $request->request->add(['number--a-status' => 2900]); // we-teillieferung
                $lieferantRequest = 'supplier_openorders';
                break;
            case 'erledigte':
                $request->request->add(['number--a-status' => 3000]); // we-komplett fertig
                $lieferantRequest = 'supplier_openorders';
                break;
            case 'BE_aus_WE':
                $request->request->add(['nlist--a-status' => '2900,3000']); //
                $request['slist--a-art'] = 'WO';
                $lieferantRequest = 'supplier_openorders';
                break;
            default:
                $lieferantRequest = 'supplier_openorders';
                break;
        }

        $response = $apiService->{$lieferantRequest}($request);
        $data = $response['data'] ?? [];
        $tableDef = [
            'header' => [
                'KDNR' => 'Lieferant',
                'NAME1' => 'Lieferantenname',
                'ANR' => 'Bestellung',
                'A_ART' => 'Typ',
//                'A_STATUS' => 'Status',
                'AUFTRAG_DATUM' => 'BE-Datum',
                'STEUER_BETRAG' => 'Steuerbetrag',
                'REBETNETTO' => 'Netto',
            ],
            'columns' => [
                'KDNR' => ['type' => 'integer'],
                'NAME1' => ['type' => 'string'], // 'fnlink' => '/mis/stat/vk/rgjournal_kd', 'fnlinkid' => 'KDNR'],
                'ANR' => ['type' => 'integer'],
                'A_ART' => ['type' => 'string'],
//                'A_STATUS' => ['type' => 'integer'],
                'AUFTRAG_DATUM' => ['type' => 'date'],
                'STEUER_BETRAG' => ['type' => 'currency'],
                'REBETNETTO' => ['type' => 'currency'],
            ],
            'meta' => [
                'keyname' => 'kdnr'
            ],
            'footer' => [
                'STEUER_BETRAG' => ['fn' => 'sum'],
                'REBETNETTO' => ['fn' => 'sum'],
            ]
        ];

        return view('mis::stat.ek.lieferant.openorders', compact('data', 'tableDef', 'request'));
    }
}
