<?php

namespace App\modules\Mis\Controllers;

use App\Http\Controllers\Controller;
use App\modules\Mis\Models\BikrKstAbteilung;
use App\modules\Mis\Models\BikrKstBereich;
use App\modules\Mis\Models\BikrLohnkosten;
use Illuminate\Http\Request;
use function Laravel\Prompts\error;

class MisLohnkostenController extends Controller
{
    public function index()
    {
        $tableDef = BikrLohnkosten::indexColumnSettings();
        $data = BikrLohnkosten::yearOverview();
        return view('mis::klr.stammdaten.lohnkosten.index', compact('tableDef', 'data'));
    }

    public function show($id)
    {
        $first = BikrLohnkosten::find($id);
        $jahr = $first->jahr;
        $option = 'abteilung';
        $view = 'mis::klr.stammdaten.lohnkosten.show_abt';
        if (is_null($first->bikr_kst_abteilungen_id)) {
            $option = 'bereich';
            $view = 'mis::klr.stammdaten.lohnkosten.show';
        }
        $data = BikrLohnkosten::where('jahr','=',$first->jahr)->with('bereich')->with('abteilung')->get();
        return view($view, compact('data','jahr','option'));
    }

    public function create()
    {
        return view('mis::klr.stammdaten.lohnkosten.create');
    }

    public function edit($jahr)
    {
        $data = BikrLohnkosten::where('jahr','=',$jahr)->with('bereich')->with('abteilung')->get();
        $option = 'Abteilung';
        $view = 'mis::klr.stammdaten.lohnkosten.edit_abt';
        if (is_null($data->first()->bikr_kst_abteilungen_id)) {
            $option = 'Bereich';
            $view = 'mis::klr.stammdaten.lohnkosten.edit';
        }
        return view($view, compact('data','jahr','option'));
    }

    public function create_step_b(Request $request)
    {
        $attributes = $request->validate([
            'jahr' => ['required', 'unique:bikr_lohnkosten,jahr']
        ]);

        $jahr = $request->jahr;

        switch($request->option){
            case 'bereich':
                $option= 'Bereich';
                $view = 'mis::klr.stammdaten.lohnkosten.create_bereich';
                $kst = BikrKstBereich::all();
                break;
            case 'abteilung':
                $option= 'Abteilung';
                $view = 'mis::klr.stammdaten.lohnkosten.create_abteilung';
                $kst = BikrKstAbteilung::with('bereich')->get();
                break;
        }

        return view($view, compact('option', 'jahr', 'kst'));
    }

    public function delete($jahr)
    {
        BikrLohnkosten::where('jahr', '=', $jahr)->forceDelete();
        return redirect('mis/klr/stammdaten/lohnkosten?t='.time());
    }

    public function store(Request $request)
    {
        $attributes = $request->validate([
            'lohn' => 'required|array',
            'lohn.*' => 'numeric|nullable',
            'gehalt' => 'required|array',
            'gehalt.*' => 'numeric|nullable',
            'sozialabgaben' => 'required|array',
            'sozialabgaben.*' => 'numeric|nullable',
        ]);

        // $key is ohne of the three columns (lohn, gehalt, sozialabgaben)
        // $value is the array of Fields with index as "bereich"
        $records = [];
        // collect all data from different areas and build a record with all fields from all areas
        foreach ($attributes as $key => $data) {
            foreach ($data as $id => $value) {
                $records[$id]['bikr_kst_bereiche_id'] = $id;
                $records[$id][$key] = $value;
                $records[$id]['jahr'] = $request->jahr;
                $records[$id]['created_at'] = now();
            }
        }

        \DB::beginTransaction();
        try {
            foreach ($records as $id => $record) {
                BikrLohnkosten::create($record);
            }
            \DB::commit();
        } catch (\Throwable $e) {
            \DB::rollBack();
            return "Something went wrong!<br>" . $e->getMessage();
        }

        return redirect('mis/klr/stammdaten/lohnkosten?t='.time());
    }

    public function store_abt(Request $request)
    {
        $attributes = $request->validate([
            'jahr' => ['required', 'unique:bikr_lohnkosten,jahr'],
            'bereich' => 'required|array',
            'bereich.*' => 'numeric|nullable',
            'lohn' => 'required|array',
            'lohn.*' => 'numeric|nullable',
            'gehalt' => 'required|array',
            'gehalt.*' => 'numeric|nullable',
            'sozialabgaben' => 'required|array',
            'sozialabgaben.*' => 'numeric|nullable',
        ]);
        unset($attributes['jahr']);
        unset($attributes['option']);

        $records = [];
        foreach ($attributes as $key => $data) {
            foreach ($data as $id => $value) {
                $records[$id]['bikr_kst_bereiche_id'] = $attributes['bereich'][$id];
                $records[$id]['bikr_kst_abteilungen_id'] = $id;
                $records[$id][$key] = $value;
                $records[$id]['jahr'] = $request->jahr;
                $records[$id]['created_at'] = now();
            }
        }

        \DB::beginTransaction();
        try {
            foreach ($records as $id => $record) {
                BikrLohnkosten::create($record);
            }
            \DB::commit();
        } catch (\Throwable $e) {
            \DB::rollBack();
            return "Something went wrong!<br>" . $e->getMessage();
        }

        return redirect('mis/klr/stammdaten/lohnkosten?t='.time());
    }

    public function update(Request $request)
    {
        $attributes = $request->validate([
            'jahr' => ['required', 'numeric'],
            'lohn' => 'required|array',
            'lohn.*' => 'numeric|nullable',
            'gehalt' => 'required|array',
            'gehalt.*' => 'numeric|nullable',
            'sozialabgaben' => 'required|array',
            'sozialabgaben.*' => 'numeric|nullable',
        ]);
        unset($attributes['jahr']);

        // $key is ohne of the three columns (lohn, gehalt, sozialabgaben)
        // $value is the array of Fields with index as "bereich"
        $records = [];
        // collect all data from different areas and build a record with all fields from all areas
        foreach ($attributes as $key => $data) {
            foreach ($data as $id => $value) {
//                $records[$id]['bikr_kst_bereiche_id'] = $id;
                $records[$id][$key] = $value;
                $records[$id]['jahr'] = $request->jahr;
                $records[$id]['created_at'] = now();
            }
        }

        \DB::beginTransaction();
        try {
            foreach ($records as $id => $record) {
                $lk = BikrLohnkosten::find($id);
                $lk->update($record);
            }
            \DB::commit();
        } catch (\Throwable $e) {
            \DB::rollBack();
            return "Something went wrong!<br>" . $e->getMessage();
        }

        return redirect('mis/klr/stammdaten/lohnkosten?t='.time());
    }
}
