<?php

namespace App\modules\Mis\Controllers;

use App\Http\Controllers\Controller;
use App\modules\Mis\Models\BikrKtArtikel;
use App\modules\Mis\Models\BikrKtGruppen;
use App\modules\Mis\Models\BikrKtProdukte;

class MisKostentraegerController extends Controller
{
    /**
     * CRUD Section
     */

    public function index()
    {
        $tableDef = BikrKtGruppen::indexColumnSetting();
        $data = BikrKtGruppen::all();
        return view('mis::klr.stammdaten.kostentraeger.index', compact('data', 'tableDef'));
    }

    public function create()
    {
        return view('mis::klr.stammdaten.kostentraeger.create');
    }

    public function show(BikrKtGruppen $kt)
    {
        // Produkte for Kostentraeger
        $tableDef = BikrKtProdukte::indexColumnSetting();
        $produkte = BikrKtProdukte::where('bikr_kt_gruppen_id', '=', $kt->id)->get();

        return view(
            'mis::klr.stammdaten.kostentraeger.show',
            compact('produkte', 'tableDef', 'kt')
        );
    }

    public function edit(BikrKtGruppen $kt)
    {
        return view('mis::klr.stammdaten.kostentraeger.edit', compact('kt'));
    }

    public function store(\Request $request)
    {
        request()->validate([
            'name' => 'required',
            'bezeichnung' => 'sometimes|required',
            'beschreibung' => 'sometimes|required',
        ]);

        BikrKtGruppen::create([
            'name' => request('name'),
            'bezeichnung' => request('bezeichnung'),
            'beschreibung' => request('beschreibung'),
        ]);

        return redirect()->route('mis.klr.stammdaten.kostentraeger');
    }

    public function delete(BikrKtGruppen $kt)
    {
        $kt->delete();
        return redirect()->route('mis.klr.stammdaten.kostentraeger');
    }

    public function update(\Request $request, BikrKtGruppen $kt)
    {
        request()->validate([
            'name' => 'required',
            'bezeichnung' => 'sometimes|required',
            'beschreibung' => 'sometimes|required',
        ]);

        $kt->update([
            'name' => request('name'),
            'bezeichnung' => request('bezeichnung'),
            'beschreibung' => request('beschreibung'),
        ]);

        return redirect()->route('mis.klr.stammdaten.kostentraeger', ['lastChanged' => $kt->id]);
    }


    /**
     * BikrKtGruppen section
     */
    public function showStructure()
    {
        $kostentraeger = BikrKtGruppen::with('produkte')->get();

        return view('mis::klr.stammdaten.kostentraeger.structure', compact('kostentraeger'));
    }

    public function createProduct(BikrKtGruppen $kt)
    {
        return view('mis::klr.stammdaten.kostentraeger.create_produkt', compact('kt'));
    }

    public function storeProdukt(\Request $request, BikrKtGruppen $kt)
    {
        request()->validate([
            'name' => 'required',
            'bezeichnung' => 'sometimes|required',
            'beschreibung' => 'sometimes|required',
        ]);

        $produkt = BikrKtProdukte::create([
            'name' => request('name'),
            'bikr_kt_gruppen_id' => request('kostentraeger'),
            'bezeichnung' => request('bezeichnung'),
            'beschreibung' => request('beschreibung'),
        ]);

        return redirect()->route('mis.klr.stammdaten.kostentraeger.show'  , ['kt' => request('kostentraeger'), 'lastChanged' => $produkt->id]);
    }

    public function showProdukt(BikrKtProdukte $prod)
    {
        $kt = BikrKtGruppen::find($prod->bikr_kt_gruppen_id);
        $artikel = $kt->artikel;
        $tableDef = BikrKtArtikel::indexColumnSetting();
        return view('mis::klr.stammdaten.kostentraeger.show_produkt', compact('prod', 'kt', 'artikel', 'tableDef'));
    }

    public function createArtikel(BikrKtProdukte $prod)
    {
        return view('mis::klr.stammdaten.kostentraeger.create_artikel', compact('prod'));
    }
}
