<?php

namespace App\modules\Mis\Controllers;

use App\Http\Controllers\Controller;
use App\modules\Mis\Models\BikrKstAbteilung;
use App\modules\Mis\Models\BikrKstBereich;

class MisKostenstellenController extends Controller
{

    public function showStructure()
    {
        $kostenstellen = BikrKstBereich::with('abteilungen')->get();

        return view('mis::klr.stammdaten.kostenstelle.structure', compact('kostenstellen'));
    }

    /**
     * CRUD Section
     */

    public function index()
    {
        $tableDef = BikrKstBereich::indexColumnSetting();
        $data = BikrKstBereich::all();
        return view('mis::klr.stammdaten.kostenstelle.index', compact('data', 'tableDef'));
    }

    public function create()
    {
        return view('mis::klr.stammdaten.kostenstelle.create');
    }

    public function show(BikrKstBereich $kstBereich)
    {
        $tableDef = BikrKstAbteilung::indexColumnSetting();
        $abteilungen = BikrKstAbteilung::where('bikr_kst_bereiche_id', '=', $kstBereich->id)->get();
        return view(
            'mis::klr.stammdaten.kostenstelle.show',
            compact('kstBereich', 'abteilungen', 'tableDef', 'abteilungen'));
    }

    public function edit(BikrKstBereich $kstBereich)
    {
        return view('mis::klr.stammdaten.kostenstelle.edit', compact('kstBereich'));
    }

    public function delete(BikrKstBereich $kstBereich)
    {
        $kstBereich->delete();
        return redirect('/mis/klr/stammdaten/kostenstelle');
    }

    public function store(\Request $request)
    {
        request()->validate([
            'bereich' => 'required|string',
            'bezeichnung' => 'required|string',
            'beschreibung' => 'required|string',
        ]);

        BikrKstBereich::create([
            'bereich' => request()->bereich,
            'bezeichnung' => request()->bezeichnung,
            'beschreibung' => request()->beschreibung,
        ]);

        return redirect('mis/klr/stammdaten/kostenstelle');
    }

    public function update(\Request $request, BikrKstBereich $kstBereich)
    {
        request()->validate([
            'bereich' => 'required|string',
            'bezeichnung' => 'required|string',
            'beschreibung' => 'required|string',
        ]);

        $kstBereich->update([
            'bereich' => request()->bereich,
            'bezeichnung' => request()->bezeichnung,
            'beschreibung' => request()->beschreibung,
        ]);

        return redirect()->route('mis.klr.stammdaten.kostenstelle', ['lastChanged' => $kstBereich->id]);
    }
}
