<?php

namespace App\modules\Mis\Controllers;

use App\Http\Controllers\Controller;
use App\modules\Mis\Models\BikrKstAbteilung;
use App\modules\Mis\Models\BikrKstBereich;

class MisAbteilungenController extends Controller
{
    public function create(BikrKstBereich $kstBereich)
    {
        $options = [
            'h' => 'Hilfskostenstelle',
            'k' => 'Kostenstelle'
        ];

        return view('mis::klr.stammdaten.abteilung.create', compact('kstBereich', 'options'));
    }


    public function show(BikrKstAbteilung $abteilung)
    {
        return view('mis::klr.stammdaten.abteilung.show', compact('abteilung'));
    }


    public function edit(BikrKstAbteilung $abteilung)
    {
        $options = [
            'h' => 'Hilfskostenstelle',
            'k' => 'Kostenstelle'
        ];
        return view('mis::klr.stammdaten.abteilung.edit', compact('abteilung', 'options'));
    }


    public function delete(BikrKstAbteilung $abteilung)
    {
        $abteilung->delete();
        return redirect()->route('mis.klr.stammdaten.kostenstelle.show'  , ['kstBereich' => $abteilung->bereich->id]);
    }


    public function store(\Request $request)
    {
        $kstBereich = BikrKstBereich::find(request('bereich'));

        request()->validate([
            'abteilung' => 'required|string',
            'bezeichnung' => 'required|string',
            'beschreibung' => 'required|string',
            'type' => 'required|string',
            'personal' => 'required|numeric|min:0',
        ]);

        BikrKstAbteilung::create([
            'bikr_kst_bereiche_id' => request('bereich'),
            'abteilung' => request('abteilung'),
            'bezeichnung' => request('bezeichnung'),
            'beschreibung' => request('beschreibung'),
            'type' => request('type'),
            'personal' => request('personal'),
        ]);

        return redirect()->route('mis.klr.stammdaten.kostenstelle.show'  , ['kstBereich' => $kstBereich->id]);
    }


    public function update(\Request $request, BikrKstAbteilung $abteilung)
    {
        request()->validate([
            'abteilung' => 'required|string',
            'bezeichnung' => 'required|string',
            'beschreibung' => 'required|string',
            'type' => 'required|string',
            'personal' => 'required|numeric|min:0',
        ]);

        $abteilung->update([
            'abteilung' => request('abteilung'),
            'bezeichnung' => request('bezeichnung'),
            'beschreibung' => request('beschreibung'),
            'type' => request('type'),
            'personal' => request('personal'),
        ]);

        return redirect()->route('mis.klr.stammdaten.kostenstelle.show'  , ['kstBereich' => $abteilung->bereich->id, 'lastChanged' => $abteilung->id]);
    }

}
