@php
    $release = 'Release '. $moduleInfo['version'] ?? ' -not set-';
    $appName = $moduleInfo['name'] ?? '-not set-';
@endphp

<x-layout>
    <div class="my-2 dark:text-gray-200">
        <h1 class="text-2xl font-bold">{{ $moduleInfo['name'] }}</h1>
        {{ $moduleInfo['title'] }} {{ $release }}/
        <x-core::pagesections.app-state />
    </div>

    <x-core::navigation.cardgroup>

        @foreach($moduleInfo['activeModules'] as $module => $data)
            @can('visitlink', $data['meta']['link'])
                <x-core::navigation.card :data="$data" />
            @endcan
        @endforeach

    </x-core::navigation.cardgroup>

</x-layout>
