<!-- Drop Modul -->
<div x-data="{ open: false }" class="relative inline-block text-left print:hidden">
    <div>
        <button @click="open = !open"
                type="button"
                class="inline-flex w-full justify-center gap-x-1.5 rounded bg-ctrl-blue px-3 py-2 text-sm font-semibold text-ctrl-light shadow-sm ring-1 ring-inset ring-white hover:bg-ctrl-green"
                id="menu-button"
                aria-expanded="true"
                aria-haspopup="true"
        >
            Schnellstart <span><i class="fa fa-angle-down"></i></span>
        </button>
    </div>
    <div x-show="open" class="absolute right-0 z-10 mt-2 w-56 origin-top-right rounded-md bg-ctrl-blue shadow-lg ring-1 ring-black  focus:outline-none" role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1">
        <div class="py-1" role="none">
            <a href="/" @click="open = false" class="bg-ctrl-blue text-ctrl-light block px-4 py-2 text-sm hover:bg-ctrl-green" role="menuitem" tabindex="-1" id="menu-item-0">Home</a>

            @foreach($moduleNavigationInfo['activeModules'] as $name => $data)
                @can('visitlink', $data['meta']['link'])
                    <x-core::navigation.quickqccessentry :data="$data"/>
                @endcan
            @endforeach
            @auth
                <x-core::navigation.quickaccess_userentry :username="Auth()->user()->name" />
            @endauth
            <form method="POST" action="/admin/useraction" role="none">
                @csrf
                <button @click="open = false" type="submit" name="u_action" value="logout" class="text-ctrl-light block w-full pl-8 py-2 text-left text-sm hover:bg-ctrl-green" role="menuitem" tabindex="-1" id="menu-item-3">Logout</button>
{{--                <button @click="open = false" type="submit" name="u_action" value="lock" class="text-ctrl-light block w-full pl-8 py-2 text-left text-sm hover:bg-ctrl-green" role="menuitem" tabindex="-2" id="menu-item-3">Lock Screen</button>--}}
                <button @click="open = false" type="submit" name="u_action" value="usersettings" class="text-ctrl-light block w-full pl-8 py-2 text-left text-sm hover:bg-ctrl-green" role="menuitem" tabindex="-3" id="menu-item-3">Usersettings</button>
            </form>
        </div>
    </div>
</div>
<!-- Drop Modul END-->
