@php
    $meta = isset($data['meta']) ? $data['meta'] : [];
    $fn = isset($data['functions']) ? $data['functions'] : [];

    $icon = $meta['icon'] ?? 'fa-globe';
    $url = $meta['link'] ?? '#';
    $title = $meta['name'] ?? 'NAME';
    $desc = $meta['desc'] ?? 'DESC';
    $disabled = false;
    if(isset($meta['disabled']) && $meta['disabled'] == 'true') {
        $disabled = true;
    }

@endphp

@if($disabled)
    <content class="border-t border-gray-300 p-3">
            <div class="flex gap-3">
                <div>
                    <i class="fa {{ $icon }} fa-1_5x text-xl dark:text-gray-100"></i>
                </div>
                <div class="flex flex-col">
                    <div class="text-gray-300">
                        {{ $title ?? 'TITLE' }}
                    </div>
                    <description class="text-gray-400 dark:text-gray-100 text-sm">
                        {{ $desc }}
                    </description>
                </div>
            </div>
    </content>
@else
    <content class="hover:bg-gray-200 hover:dark:bg-gray-500 cursor-pointer border-t border-gray-300 p-3">
        <a href="{{ $url }}">
            <div class="flex gap-3">
                <div>
                    <i class="fa {{ $icon }} fa-1_5x text-xl dark:text-gray-100"></i>
                </div>
                <div class="flex flex-col">
                    <div class="text-blue-500 dark:text-ctrl-green">
                        {{ $title ?? 'TITLE' }}
                    </div>
                    <description class="text-gray-400 dark:text-gray-100 text-sm">
                        {{ $desc }}
                    </description>
                </div>
            </div>
        </a>
    </content>
@endif
