<!-- CARD -->
@php
    $meta = $data['meta'];
    $fn = $data['functions'] ?? [];

    $icon = $meta['icon'] ?? 'fa-global';
    $moduleurl = $meta['link'] ?? '/';
    $title = $meta['name'] ?? 'TITLE';
    $desc = $meta['desc'] ?? 'DESC';
    $disabled = false;
    if(isset($meta['disabled']) && $meta['disabled'] == 'true') {
        $disabled = true;
    }


@endphp

@can('visitlink', $moduleurl)
    <card class="flex flex-col bg-white dark:bg-gray-600 max-w-96 border border-gray-300">
        <header class="flex p-3 items-center">
            <div class="font-semibold">
                <i class="fa {{ $icon }} fa-2x dark:text-gray-100"></i>
            </div>
            <div class="w-full">
                @if($disabled)
                    <span class="font-semibold ml-3 text-gray-400 text-2xl">
                        {{ $title }}
                    </span>
                @else
                    <span class="font-semibold ml-3 text-ctrl-green text-2xl">
                        <a href="{{ $moduleurl }}">{{ $title }}</a>
                    </span>
                @endif
                <p class="ml-3 dark:text-gray-200">{{ $desc }}</p>
            </div>
        </header>

        @foreach($fn as $m => $mdata)
            @can('visitlink', $mdata['meta']['link'])
                <x-core::navigation.cardentry :data="$mdata" />
            @endcan
        @endforeach
    </card>
@endcan
<!-- CARD END -->
