@props(['options', 'name', 'label', 'value', 'ti'])

<div class="p-1">
    <label for="{{ $name }}">
        {!! $label ?? ucfirst($name) !!}
    </label>
</div>
<div>
    <select
        name="{{ $name }}"
        tabindex="{{ $ti ?? 1 }}" {{ $af ?? '' }}
        {{ $attributes->merge(['class' => 'w-full mt-1 p-1 text-sm font-mono border-[1px] border-blue-900 bg-white']) }}
    >
        @if (isset($options))
            @foreach ($options as $_key => $_value)
                <option class="_w-full" value="{{ $_key }}" {{ $value == $_key ? 'selected' : '' }}>{{ $_value }}</option>
            @endforeach
        @endif
    </select>
</div>
<div class="p-1">&nbsp;</div>
