@php use Carbon\Carbon; @endphp
@props(['name', 'label', 'value', 'ti'])

@php
    $month = Carbon::now()->month;
    $year = Carbon::now()->year;
    $options = [
        '' => "Auswahl",
    ];
    foreach (range(1, (int) $month) as $month) {
        $options[$month.'.'.$year] = $month.'.'.$year;
    }
@endphp

<div class="p-1">
    <label for="{{ $name }}">
        {!! $label ?? ucfirst($name) !!}
    </label>
</div>
<div>
    <select
        name="{{ $name }}"
        tabindex="{{ $ti ?? 1 }}" {{ $af ?? '' }}
        {{ $attributes->merge(['class' => 'w-full mt-1 p-1 text-sm font-mono border-[1px] border-blue-900 bg-white']) }}
    >
        @if (isset($options))
            @foreach ($options as $_key => $_value)
                <option class="_w-full" value="{{ $_key }}" {{ $value == $_key ? 'selected' : '' }}>{{ $_value }}</option>
            @endforeach
        @endif
    </select>
</div>
<div class="p-1">&nbsp;</div>
