<form action="{{ $action }}" {{ $attributes }}>

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">
        <div class="m-0 p-1 bg-gray-100 dark:bg-gray-500 dark:text-gray-200 grid grid-cols-[auto_1fr] gap-3 text-sm">

            <!-- Fields -->
            <div class="grid grid-cols-3 gap-y-2 _h-1">
                <div class="p-1 mb-1 bg-ctrl-tbl-blue font-bold">Field</div>
                <div class="p-1 mb-1 bg-ctrl-tbl-blue font-bold">Suche nach</div>
                <div class="p-1 mb-1 bg-ctrl-tbl-blue font-bold">Spalte</div>
                {{ $slot }}
            </div>

            <!-- Options -->
            <div  class="flex flex-col gap-0">
                <div class="p-1 mb-1 bg-ctrl-tbl-blue font-bold items-start">Optionen</div>
                {{ $options }}
            </div>
        </div>
    </div>

    @error('general')
    <p class="text-red-500 text-base font-semibold">{{ $message }}</p>
    @enderror

    <x-safweb.pagesections.pagecontrol>
        <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
        <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">Suchen<i class="fa fa-search ml-2"></i></button>
    </x-safweb.pagesections.pagecontrol>


</form>
