<?php

namespace App\modules\Core\Services;

use App\Models\User;
use Illuminate\Support\Facades\Validator;
use stdClass;

class SafwebLegacyService
{

    public function getAllOldUser($dbConnector, $fallbackEmailAddress)
    {
        $result = $this->getNotYetImpportedUser($dbConnector, $fallbackEmailAddress);
        $importUser = $result[0];
        $userIds = $result[1];
        $importUser = $this->addNameToUserList($dbConnector, $importUser, $userIds);
        return $importUser;
    }


    public function importAllOldUser($dbConnector, $fallbackEmailAddress)
    {
        $allOldUser = $this->getAllOldUser($dbConnector, $fallbackEmailAddress);
        $importedUser = [];
        foreach ($allOldUser as $user) {
            if (User::create([
                'name' => $user->name,
                'email' => $user->email,
                'login' => $user->login,
                'status' => $user->state,
                'password' => bcrypt('password'),
                'created_at' => date('Y-m-d H:i:s'),
            ])) {
                $importedUser[] = $user;
            }
        }
        return $importedUser;
    }



    protected function getNotYetImpportedUser($dbConnector, $fallbackEmailAdress = 'info@soyer.de')
    {
        $sql = "select u.uid as uid, u.login as login, u.state as state, up.prop_value as email"
            ." from users u, properties p, user_properties up"
            ." where u.uid = up.uid and p.prop_id=up.prop_id and p.prop_name='email'"
            ." ORDER BY u.login";

        $allOldUser = $this->dbRequest($dbConnector, $sql);
        $importUser = [];
        $userIds = [];
        foreach ($allOldUser as $user) {
            if(! User::where('login', $user->login)->exists()) {
                $u = new stdClass();
                $u->uid = $user->uid;
                $u->login = $user->login;
                $u->email = $user->email;
                $u->state = $user->state;
                $u->name = '';

                $validator = Validator::make(['email' => $u->email], [
                    'email' => 'required|email'
                ]);
                if ($validator->fails()) {
                    $u->email = $fallbackEmailAdress;
                }

                $importUser[$user->login] = $u;
            }
            $userIds[] = $user->uid;
        }

        return [$importUser, $userIds];
    }


    protected function addNameToUserList($dbConnector, &$userList, $userIds)
    {
        if (sizeof($userList) == 0) {
            return $userList;
        }

        $sql = "select u.login as login, up.prop_value as name"
            ." from users u, properties p, user_properties up"
            ." where u.uid = up.uid and p.prop_id=up.prop_id and p.prop_name='name'"
            ." and up.uid IN (".implode(',', $userIds).")";

        $userNames = $this->dbRequest($dbConnector, $sql);

        foreach ($userNames as $userName) {
            if (isset($userList[$userName->login])) {
                $userList[$userName->login]->name = $userName->name ?? 'not found';
            }
        }

        return $userList;
    }


    protected function dbRequest($dbConnector, $sql)
    {
        return \DB::connection($dbConnector)->select($sql);
    }
}
