<?php

namespace App\modules\Core\Services;

use Illuminate\Http\Client\ConnectionException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use function Laravel\Prompts\error;

class OraApiService
{
    protected $baseUrl;

    /**
     * Create a new class instance.
     */
    public function __construct()
    {
        $uri = config('oraapi.baseurl');
        $erp = config('oraapi.erp');
        $version = config('oraapi.erp_version');

        $this->baseUrl = $uri.'/'.$erp.'/'.$version;
    }

    /**
     * Send a GET Request to an API
     *
     * @param $apiuri
     * @param $request      ['filter' => [], 'option' => [], 'columns' => []]
     * @return array|mixed
     */
    public function apiRequest($apiuri, $request)
    {
        // POST Request
        $data = $request->request->all();
        if (sizeof($data) == 0) {
            // GET Request
            $data = $request->all();
            $query = http_build_query($data);
            $apiuri .= '?'.$query;
        }

        $response = Http::get(
            $apiuri, $data
        );

        if (! $response->successful()) {
            dd($response->status(), $response->body(), $response->getReasonPhrase());
            // TODO: Show ErrorPage
        }
        return $response->json();
    }

    public function apiPOSTRequest($apiuri, $request)
    {
        $response = Http::post(
            $apiuri, $request->request->all()
        );

        if (! $response->successful()) {
            $response->throw();
        }
        return $response->json();
    }



    /**
     * MIS.VK Services
     */
    public function rechnungsjournal(Request $request)
    {
        $apiuri = $this->baseUrl.'/vk/rgjournal';
        $response = $this->apiRequest($apiuri, $request);
        return $response;
    }

    public function customer_orders(Request $request)
    {
        $apiuri = $this->baseUrl.'/vk/customer_orders';
        $response = $this->apiRequest($apiuri, $request);
        return $response;
    }

    public function customer_orders_pg(Request $request)
    {
        $apiuri = $this->baseUrl.'/vk/customer_orders_pg';
        $response = $this->apiRequest($apiuri, $request);
        return $response;
    }

    /**
     * MIS.EK Services
     */
    public function supplier_openorders(Request $request)
    {
        $apiuri = $this->baseUrl.'/ek/supplier-openorders';
        $response = $this->apiRequest($apiuri, $request);
        return $response;
    }



    /**
     * DB Admin Services
     */

    public function dbAdminSqlExec(Request $request)
    {
        $apiuri = $this->baseUrl.'/sql/exec';
        $response = $this->apiRequest($apiuri, $request);
        return $response;
    }
}
