<?php

namespace App\modules\Core\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Context;
use Schema;

class ListTableDefinitionService
{
    protected $tableDef = [];

    public function __construct()
    {
        $this->tableDef = [
            'header' => [],
            'columns' => [],
            //'meta' => null,
            //'footer' => null,
        ];
    }

    public function getDefinitionForModel($model)
    {
        $modelData = $this->getModelData($model);
        $this->tableDef = $this->passModelDataToTableDefinition($modelData);
        return $this->tableDef;
    }

    protected function getModelData($model)
    {
        $Model = new $model;
        $tableName = $Model->getTable();
        $keyName = $Model->getKeyName();

        /**
         * columnLabels() must be defined in the Model by yourself.
         * If this Function exists, it should return the ColumnLabels Array.
         * Otherwise, we guess here the Columns from Schema.
         */
        if (method_exists($Model, 'columnLabels')) {
            $columnLabels = $Model->columnLabels();
        } else {
            $columns = $this->getModelColumns($tableName);
            $columnLabels = array_map('ucfirst', $columns);
        }

        /**
         * columnTypes() must be defined in the Model by yourself.
         * If this Function exists, it should return the ColumnType Array.
         * Otherwise, we guess here the Columns from Schema.
         */
        if (method_exists($Model, 'columnTypes')) {
            $columnTypes = $Model->columnTypes();
        } else {
            /**
             * Create the List of ColumnTypes manually with a default fnedit Link on the
             * Model.keyName Column.
             */
            $columnTypes = [];
            foreach ($columns as $column) {
                $columnType = Schema::getColumnType($tableName, $column);
                if ($keyName == $column) {
                    // create the Link to show Details. Assumption is a default-link to show Objects:
                    // modul/segment/object/id
                    $modulName = Context::get('modulName');
                    $modulNameSegment = Context::get('modulNameSegment');
                    $modelName = strtolower(class_basename($Model));
                    $fnEditLink = str_replace('//', '/', '/'.$modulName.'/'.$modulNameSegment.'/'.$modelName);
                    $columnType = ['type' => $columnType, 'fnedit' => $fnEditLink];
                }
                $columnTypes[$column] = $columnType;
            }
        }

        return [
            'tablename' => $tableName,
            'columnlabels' => $columnLabels,
            'columntypes' => $columnTypes,
        ];
    }

    protected function getModelColumns($tableName)
    {
        $columns = Schema::getColumnListing($tableName);
        return $columns;
    }

    protected function passModelDataToTableDefinition($modelData)
    {
        $this->tableDef['header'] = $modelData['columnlabels'];
        $this->tableDef['columns'] = $modelData['columntypes'];
        return $this->tableDef;
    }


}
