<?php

namespace App\modules\Core\Services;

class FilesystemService
{
    /**
     * Search recursive for files in all modules directories beginnign from the startdirectory.
     * Returns a list of models in a flat array.
     *
     * @param $path     startpath, if empty app_path() is used
     * @param $models   Array of Models, initially empty
     * @return array|false|mixed
     */
    public function scanForModels($path = null, &$models = [])
    {
        if (is_null($path)) {
            $path = app_path();
        }

        $folders = scandir($path);
        $directories = array_slice($folders, 2); // skip . and ..

        foreach ($directories as $entry) {
            $filepath = $path . DIRECTORY_SEPARATOR . $entry;
            if (is_dir($filepath) && strtolower($entry) !== 'models') {
                $this->scanForModels($filepath, $models);
            } elseif (is_dir($filepath)) {
                $_models = scandir($filepath);
                $modelList = array_slice($_models, 2); // skip . and ..
                $models = array_merge($modelList, $models);
            }
        }
        $cleanModels = array_map(function ($model) { return pathinfo($model, PATHINFO_FILENAME); }, $models);
        return $cleanModels;
    }
}
