<?php

namespace App\modules\Core\Providers;

use App\modules\Core\Composers\QuickAccessComposer;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades;
use Livewire\Livewire;
use App\modules\Core\Http\Livewire\NavigationSidebar;

class CoreServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');
        $this->mergeConfigFrom(__DIR__.'/../config.php', 'core');

        $this->loadViewsFrom(__DIR__ . '/../resources/views', 'core');

        // Views
        Facades\View::composer('core::components.navigation.quickaccess', QuickAccessComposer::class);

        // Livewire Components in non Standard Folder
        Livewire::component('navigation-sidebar', NavigationSidebar::class  );
    }
}
