<?php

namespace App\modules\Core\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class SafwebAiController extends Controller
{
    public function hellosafweb()
    {
        return view('core::safwebai.index');
    }

    public function askAI(Request $request)
    {
        $request->validate(['prompt' => 'required|string:min:5']);
        $prompt = $request->get('prompt');

        $response = HTTP::withToken(config('services.openai.secret'))->post(
            'https://api.openai.com/v1/responses',
            [
                'model' => 'gpt-4o-mini',
                'input' => [
                    [
                        'role' => 'system',
                        'content' => 'Verhalte dich wie ein Tutor für SIVAS ERP Schulungen'
                    ],
                    [
                        'role' => 'user',
                        'content' => $prompt
                    ]
                ]
            ]
        );
        if ($response->ok()) {
            $responses[] = $response->json('output.0.content.0.text');
            return view('core::safwebai.index', compact('responses'));
        } else {
            return view('core::safwebai.index', compact('response'));
        }
    }
}
