<?php

namespace App\modules\Core\Controllers;

use App\Http\Controllers\Controller;
use App\Livewire\Actions\Logout;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class SafAuthController extends Controller
{
    public function logout()
    {
        Session::invalidate();
        Session::regenerateToken();

        return redirect('/');
    }

    public function useraction(Request $request, Logout $logout)
    {
        $request->validate([
            'u_action' => 'required',
        ]);

        switch ($request->u_action) {
            case 'logout':
                //$logout();
                Auth::logout();
                return redirect('/');
                break;
            case 'lock':
                break;
            case 'usersettings':
                break;
        }
    }
}
