<?php

use App\modules\Admin\Controllers\AdminController;
use App\modules\Admin\Controllers\GroupAdminController;
use App\modules\Admin\Controllers\PermissionAdminController;
use App\modules\Admin\Controllers\RoleAdminController;
use App\modules\Admin\Controllers\SafwebLegacyController;
use App\modules\Admin\Controllers\UserAdminController;
use App\modules\Admin\Controllers\SqlSupportContoller;
use Illuminate\Support\Facades\Route;


Route::middleware('auth')->group(function () {
    // Modulnavigation
    Route::get('/admin', [AdminController::class, 'index']);
    Route::get('/admin/users', [AdminController::class, 'users']);

    Route::view('/admin/sysc', 'admin::info.core');

    // USER
    Route::get('/admin/users/user', [UserAdminController::class, 'index'])->name('admin.user');
    Route::get('/admin/users/user/create', [UserAdminController::class, 'create']);
    Route::get('/admin/users/user/{user}', [UserAdminController::class, 'show'])->name('admin.user.show');
    Route::get('/admin/users/user/{user}/edit', [UserAdminController::class, 'edit']);
    Route::get('/admin/users/user/{user}/cpwd', [UserAdminController::class, 'changePassword']);
    Route::get('/admin/users/user/{user}/delete', [UserAdminController::class, 'destroy']);
    Route::post('/admin/users/user', [UserAdminController::class, 'store']);
    Route::patch('/admin/users/user/{user}', [UserAdminController::class, 'update']);
    Route::patch('/admin/users/user/cpwd/{user}', [UserAdminController::class, 'updatePassword']);

    // GROUPS
    Route::get('/admin/users/groups', [GroupAdminController::class, 'index'])->name('admin.groups');
    Route::get('/admin/users/group/create', [GroupAdminController::class, 'create']);
    Route::get('/admin/users/group/{group}', [GroupAdminController::class, 'show']);
    Route::match(['post','get'], '/admin/users/group/{group}/edit', [GroupAdminController::class, 'edit']);
    Route::match(['post','get'], '/admin/users/group/{group}/delete', [GroupAdminController::class, 'destroy']);
    Route::post('/admin/users/group', [GroupAdminController::class, 'store']);
    Route::patch('/admin/users/group/{group}', [GroupAdminController::class, 'update'])->name('admin.group.update');

    // USER GROUP PERMISSIONS
    Route::get('/admin/users/permissions', [PermissionAdminController::class, 'index'])->name('admin.permissions');
    Route::get('/admin/users/permission/scanmenus', [PermissionAdminController::class, 'scanmenus'])->name('admin.permissions.scanmenus');
    Route::get('/admin/users/permission/scanmodels', [PermissionAdminController::class, 'scanmodels'])->name('admin.permissions.scanmodels');
    Route::get('/admin/users/permission/create', [PermissionAdminController::class, 'create']);
    Route::get('/admin/users/permission/{permission}', [PermissionAdminController::class, 'show']);
    Route::post('/admin/users/permission', [PermissionAdminController::class, 'store']);
    Route::post('/admin/users/permission/addscanned', [PermissionAdminController::class, 'addScanned']);
    Route::post('/admin/users/permission/addscannedmodels', [PermissionAdminController::class, 'addScannedModels']);

    // USER ROLES
    Route::get('/admin/users/roles', [RoleAdminController::class, 'index'])->name('admin.roles');
    Route::get('/admin/users/role/create', [RoleAdminController::class, 'create']);
    Route::get('/admin/users/role/{role}', [RoleAdminController::class, 'show']);
    Route::match(['get', 'post'],'/admin/users/role/{role}/edit', [RoleAdminController::class, 'edit']);
    Route::post('/admin/users/role', [RoleAdminController::class, 'store'])->name('admin.role.store');
    Route::patch('/admin/users/role/{role}', [RoleAdminController::class, 'update'])->name('admin.role.update');


    // USERIMPORT LEGACY
    Route::get('/admin/safweb1_userimport',[SafwebLegacyController::class,'user_import']);
    Route::get('/admin/safweb1_userimport_exec',[SafwebLegacyController::class,'user_import_exec']);

    Route::post('/admin/useraction',[UserAdminController::class,'useraction']);
    Route::get('/admin/usersettings',[UserAdminController::class,'usersettings'])->name('admin.usersettings');
    Route::patch('/admin/usersettings/{user}', [UserAdminController::class, 'update_usersettings']);

    Route::get('/admin/orasql-support',[SqlSupportContoller::class,'orasqlsupport']);
    Route::post('/admin/orasql/exec',[SqlSupportContoller::class,'sqlExec']);
});
