<x-layout>

    <form method="POST" action="/admin/usersettings/{{ $currentUser->id }}">
        @method('PATCH')
        @csrf

        <x-core::pagesections.pagetitle subtitle="...mit Bedacht">Ändern Sie Ihre Einstellungen</x-core::pagesections.pagetitle>

        <x-safweb.pagesections.pagetopnav>
            <x-safweb.components.backbutton />
            <x-safweb.components.modulbutton href="/admin" />
        </x-safweb.pagesections.pagetopnav>

        <x-safweb.forms.headline title="Einstellungen ändern" />

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2">

            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

                <x-safweb.forms.input autofocus :value="$currentUser->name" tabindex="1" name="name" size="40" />
                <x-safweb.forms.input :value="$currentUser->login" tabindex="-1" name="login" size="40" readonly />
                <x-safweb.forms.email :value="$currentUser->email" tabindex="2" name="email" size="40" />
                <x-safweb.forms.checkbox tabindex="-1" name="status" label="aktiv" :value="$currentUser->status" disabled />
                <x-safweb.forms.password autofocus tabindex="3" name="password" label="{{ __('neues Passwort') }}" size="40" />
                <x-safweb.forms.password tabindex="4" name="password_confirmation"  label="{{ __('neues Passwort wiederholen') }}" size="40" />

            </div>
        </div>

        <x-safweb.pagesections.pagecontrol>
            <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300" tabindex="5">Reset<i class="fa fa-arrow-down ml-2"></i></button>
            <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300" tabindex="6">speichern<i class="fa fa-save ml-2"></i></button>
        </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
