<x-layout>
    <x-core::pagesections.pagetitle subtitle="Anwender Informationen">Administration</x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/admin" />
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="Informationen zum Anwender" />

    <!-- FORM Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2">

        <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

            <x-safweb.forms.info autofocus tabindex="1" name="name" :value="$user->name" size="40" />
            <x-safweb.forms.info tabindex="2" name="login" :value="$user->login" size="40" />
            <x-safweb.forms.info tabindex="3" name="email" :value="$user->email" size="40" />
            <x-safweb.forms.info format="boolean" tabindex="4" name="aktiv" :value="$user->status" />
            <x-safweb.forms.info format="date" tabindex="5" name="email" :value="$user->created_at" label="angelegt am" size="40" />

            <div class="p-1 border-b-[1px] bg-ctrl-tbl-blue">
                <label for="roles[]">{{ __('roles') }}</label>
            </div>
            <div class="p-1 _border-b-[1px] border-blue-300">
                <textarea readonly disabled class="bg-gray-200 p-0" rows="4" cols="30">@foreach ($roles as $role){{ $role->name."\n" }}@endforeach</textarea>
            </div>

            <div class="p-1 border-b-[1px] bg-ctrl-tbl-blue">
                <label for="groups">{{ __('groups') }}</label>
            </div>
            <div class="p-1 _border-b-[1px] border-blue-300">
                <textarea readonly disabled class="bg-gray-200 p-0" rows="4" cols="30">@foreach($groups as $group){{ $group->name."\n" }}@endforeach</textarea>
            </div>

            <div class="p-1 bg-ctrl-tbl-blue">
                <label for="permissions">{{ __('permissions') }}</label>
            </div>
            <div class="p-1 _border-b-[1px] border-blue-300">
                <textarea readonly disabled class="bg-gray-200 p-0" rows="4" cols="60">@foreach($permissions as $permission){{ $permission."\n" }}@endforeach</textarea>
            </div>

            <div class="p-1 bg-ctrl-tbl-blue">
                <label for="userpermissions">{{ __('userpermissions') }}</label>
            </div>
            <div class="p-1 _border-b-[1px] border-blue-300">
                <textarea readonly disabled class="bg-gray-200 p-0" rows="4" cols="60">@foreach($userPermissions as $userPermission){{ $userPermission->token."\n" }}@endforeach</textarea>
            </div>

        </div>
    </div>

    <x-safweb.pagesections.pagecontrol>
        <a href="/admin/users/user/{{ $user->id }}/edit" role="button" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">bearbeiten<i class="fa fa-pencil-alt ml-2"></i></a>
        <a href="/admin/users/user/{{ $user->id }}/cpwd" role="button" class="py-1.5 mx-2 px-6 bg-ctrl-orange text-ctrl-dark hover:bg-green-300">PWD ändern<i class="fa fa-lock ml-2"></i></a>
        <a onclick="return confirm('Diesen Satz wirklich löschen?')" href="/admin/users/user/{{ $user->id }}/delete" role="button" class="py-1.5 mx-2 px-6 bg-ctrl-red text-white hover:bg-red-400">löschen<i class="fa fa-trash ml-2"></i></a>
    </x-safweb.pagesections.pagecontrol>
</x-layout>
