<x-layout>
    <form method="POST" action="/admin/users/user">
        @csrf

        <x-core::pagesections.pagetitle subtitle="Anwender erfassen">Administration</x-core::pagesections.pagetitle>

        <x-safweb.pagesections.pagetopnav>
            <x-safweb.components.backbutton />
            <x-safweb.components.modulbutton href="/admin" />
        </x-safweb.pagesections.pagetopnav>

        <x-safweb.forms.headline title="neuen Anwender anlegen" />

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2">

            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

                <x-safweb.forms.input autofocus tabindex="1" name="name" size="40" />
                <x-safweb.forms.input tabindex="2" name="login" size="40" />
                <x-safweb.forms.email tabindex="3" name="email" size="40" />
                <x-safweb.forms.checkbox tabindex="4" name="status" label="aktiv" value="0" />
                <x-safweb.forms.password tabindex="5" name="password" size="40" label="Passwort" />
                <x-safweb.forms.password tabindex="6" name="password_confirmation " size="40" label="Passwort bestätigung" />

                <div class="p-1 bg-ctrl-tbl-blue">
                    <label for="roles[]">
                        {{ __('roles') }}
                    </label>
                </div>
                <div class="px-2">
                    <select
                        name="roles[]"
                        tabindex="3"
                        multiple
                        readonly
                        size="5"
                        class = "_w-full mt-1 p-1 text-sm font-mono border-[1px] border-blue-900 bg-white"
                    >
                        @foreach ($roles as $role)
                            <option class="_w-full" value="{{ $role->id }}" {{ $user->hasRole($role->id) ? 'selected' : '' }}>
                                {{ $role->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

            </div>
        </div>

        <x-safweb.pagesections.pagecontrol>
            <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
            <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">speichern<i class="fa fa-save ml-2"></i></button>
        </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
