<x-layout>
    <form method="POST" action="/admin/users/user/cpwd/{{ $user->id }}">
        @method('PATCH')
        @csrf

        <x-core::pagesections.pagetitle subtitle="Passwort ändern">Administration</x-core::pagesections.pagetitle>

        <x-safweb.pagesections.pagetopnav>
            <x-safweb.components.backbutton />
            <x-safweb.components.modulbutton href="/admin" />
        </x-safweb.pagesections.pagetopnav>

        <x-safweb.forms.headline title="für User {{ $user->name }}" />

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2">

            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">
                <x-safweb.forms.info name="login" :value="$user->login" />
                <x-safweb.forms.info name="name" :value="$user->name" />
                <x-safweb.forms.password autofocus tabindex="1" name="password" label="{{ __('neues Passwort') }}" size="40" />
                <x-safweb.forms.password tabindex="2" name="password_confirmation"  label="{{ __('neues Passwort wiederholen') }}" size="40" />
            </div>
        </div>

        <x-safweb.pagesections.pagecontrol>
            <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
            <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">speichern<i class="fa fa-save ml-2"></i></button>
        </x-safweb.pagesections.pagecontrol>

    </form>

</x-layout>
