<x-layout>
    <x-safweb.pagesections.pagetitle subtitle="">SQL Result</x-safweb.pagesections.pagetitle>

    @if ($executed_sql != '')
        <b>Executed SQL by Oracle:</b>
        <br>
        {!! $executed_sql !!}
        <br>
    @endif

    <table class="table table-sm border-collapse text-sm">

        <thead>
            <tr class="bg-ctrl-tbl-blue px-2 text-left text-sm font-semibold border border-gray-300 text-nowrap">
                @foreach($data[0] ?? [] as $col => $v)
                    <th>{{ $col }}</th>
                @endforeach
            </tr>
        </thead>

        <tbody>
            @foreach($data as $idx => $row)
                @php
                    $rowColor = '';
                    if ($loop->even) {
                        $rowColor = 'bg-gray-200';
                    }
                    $textRight = '';
                    $cellColor = '';
                @endphp

                <tr class="border border-gray-300 {{ $rowColor }}">
                    @foreach($row as $name => $value)
                    <td @class([
                        'border',
                        'border-gray-300',
                        'text-sm',
                        $textRight,
                        $cellColor,
                        'px-2',
                        'text-nowrap',
                    ])>
                        {!! Str::of($value)->limit(30) !!}
                    </td>

                    @endforeach

                </tr>
            @endforeach
        </tbody>
    </table>

</x-layout>
