<x-layout>
    <x-core::pagesections.pagetitle subtitle="">
        Oracle SQL Support Editor
    </x-core::pagesections.pagetitle>

    <div class="mt-5">
        <form method="POST" action="orasql/exec">
            @csrf

            <div class="flex space-x-4 mt-4">
                <div>
                    <label for="database">Datenbank</label>
                    <select id="database" name="database">
                        <option value="test">Test</option>
                        <option value="production">Produktiv</option>
                    </select>
                </div>
                <div>
                    <label for="user">Username</label>
                    <input id="user" name="username" value="{{ old('username') }}" />
                </div>
                <div>
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" />
                </div>
            </div>

            <div class="flex space-x-4 mt-4">
                <div>
                    <label for="limit">Limit</label>
                    <input id="limit" name="limit" value="50" />
                </div>
                <div>
                    <label for="linearlist">linear List</label>
                    <input type="checkbox" id="linearlist" name="linearlist" value="1" />
                </div>
                <div>
                    <label for="showsql">Show SQL</label>
                    <input type="checkbox" id="showsql" name="showsql" value="1" />
                </div>
            </div>

            <div class="mt-4">
                <div class="flex flex-col">
                    <label for="sql">SQL Statement</label>
                    <textarea id="sql" name="sql" cols="700" rows="15">{{ old('sql') }}</textarea>
                </div>
            </div>

            <div class="flex space-x-4 mt-4">
                <div>
                    <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">Reset<i class="fa fa-arrow-down ml-2"></i></button>
                </div>
                <div>
                    <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">Execute<i class="fa fa-bolt ml-2"></i></button>
                </div>
            </div>
        </form>

        @if ($errors->any())
            <div class="text-red-400">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
    </div>
</x-layout>
