<x-layout>
    <x-core::pagesections.edit_view :model="$model" action="{{ route('admin.role.update', $model->id) }}">

        <x-safweb.forms.input autofocus tabindex="1" name="name" size="30" value="{{ $model->name }}"/>
        <x-safweb.forms.input tabindex="2" name="description" size="60"  value="{{ $model->description }}"/>

        <div class="p-1 bg-ctrl-tbl-blue">
            <label for="groups[]">
                {{ __('groups') }}
            </label>
        </div>
        <div class="px-2">
            <select
                name="groups[]"
                tabindex="3"
                multiple
                size="10"
                class = "_w-full mt-1 p-1 text-sm font-mono border-[1px] border-blue-900 bg-white"
            >
                @foreach ($groups as $group)
                    <option class="_w-full" value="{{ $group->id }}" {{ $model->hasGroup($group->id) ? 'selected' : '' }}>
                        {{ $group->name }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="p-1">&nbsp;</div>
    </x-core::pagesections.edit_view>
</x-layout>
