<x-layout>
    <form method="POST" action="/admin/users/role">
        @csrf

        <x-core::pagesections.pagetitle subtitle="{{ __('create Role') }}">{{ __('Administration') }}</x-core::pagesections.pagetitle>

        <x-safweb.pagesections.pagetopnav>
            <x-safweb.components.backbutton />
            <x-safweb.components.modulbutton href="/admin" />
        </x-safweb.pagesections.pagetopnav>

        <x-safweb.forms.headline title="{{ __('create a new Role') }}" />

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2">

            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">
                <x-safweb.forms.input autofocus tabindex="1" name="name" label="{{ __('Role') }}" size="40" />
                <x-safweb.forms.input tabindex="2" name="description" label="{{ __('Description') }}" size="40" />
                <div class="p-1 bg-ctrl-tbl-blue">
                    <label for="group">
                        {{ __('Group') }}
                    </label>
                </div>
                <div class="px-2">
                    <select name="groups[]" class="_w-1/4 mt-1 p-0.5 text-sm font-mono border-[1px] border-blue-900 bg-white" multiple>
                        @foreach ($groups as $group)
                            <option value="{{ $group->id }}">{{ $group->name }}</option>
                        @endforeach
                    </select>
                </div>

            </div>
        </div>

        <x-safweb.pagesections.pagecontrol>
            <button type="reset"  class="py-1.5 mx-2 px-6 bg-ctrl-orange hover:bg-orange-300">{{ __('Reset') }}<i class="fa fa-arrow-down ml-2"></i></button>
            <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">{{ __('save') }}<i class="fa fa-save ml-2"></i></button>
        </x-safweb.pagesections.pagecontrol>

    </form>
</x-layout>
