<x-layout>
    <x-core::pagesections.pagetitle subtitle="{{ __('Detail View') }}">
        {{ ucfirst(Context::get('modulName')) }}
    </x-core::pagesections.pagetitle>

    <x-safweb.pagesections.pagetopnav>
        <x-safweb.components.backbutton />
        <x-safweb.components.modulbutton href="/{{ Context::get('modulName') }}" />
    </x-safweb.pagesections.pagetopnav>

    <x-safweb.forms.headline title="{{ __('Detailed information for') }} {{ ucfirst(__('permission')) }}" />


    <div class="grid grid-cols-2 gap-4 mb-4">
        <div class="border-2 border-dashed rounded-lg border-gray-300 dark:border-gray-600 _h-full _md:h-1/2 overflow-auto">
            <x-core::pageelements.subheadline>{{ __('stored Permissions') }}</x-core::pageelements.subheadline>
            <x-safweb.table :tableDef="$tableDef" :data="$data"/>
        </div>
        <div class="border-2 border-dashed rounded-lg border-gray-300 dark:border-gray-600 _h-full _md:h-72 overflow-auto">
            <x-core::pageelements.subheadline>{{ __('scanned Permissions') }}</x-core::pageelements.subheadline>

            <form method="POST" action="/admin/users/permission/addscanned">
                @csrf

                @foreach($modulPermissions as $modulPermission)
                    <p class="text-base">
                        <input class="disabled:text-gray-300" type="checkbox" name="scanpermission[]" value="{{ $modulPermission['value'] }}" checked {{ $modulPermission['stored'] == 'true' ? 'disabled' : '' }} /> {{ $modulPermission['token']}}
                    </p>
                @endforeach

                <x-safweb.pagesections.pagecontrol>
                    <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">{{ __('accept selection') }}<i class="fa fa-save ml-2"></i></button>
                </x-safweb.pagesections.pagecontrol>

            </form>

        </div>

    </div>

</x-layout>
