<x-layout>
    <form method="POST" action="/admin/users/group/{{$group->id}}/edit">
        @csrf

        <x-core::pagesections.pagetitle subtitle="{{ __('show Group') }}">{{ __('Administration') }}</x-core::pagesections.pagetitle>

        <x-safweb.pagesections.pagetopnav>
            <x-safweb.components.backbutton />
            <x-safweb.components.modulbutton href="/admin" />
        </x-safweb.pagesections.pagetopnav>

        <x-safweb.forms.headline title="{{ __('show Group') }}" />

        <!-- FORM Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-2">

            <div class="m-0 p-1 bg-gray-200 grid grid-cols-[auto_1fr] text-sm">

                <x-safweb.forms.info autofocus tabindex="1" name="name" value="{{ $group->name }}" label="{{ __('Group') }}" size="40" />
                <x-safweb.forms.info tabindex="2" name="description" value="{{ $group->description }}" label="{{ __('Description') }}" size="40" />

                <div class="p-1 bg-ctrl-tbl-blue">
                    <label for="permission">
                        Permission
                    </label>
                </div>
                <div class="px-2">
                    <textarea class="p-0.5 text-sm font-mono border-[1px] border-blue-900 bg-gray-100" id="permission" rows="10" cols="60" readonly>{{ $permissionString }}</textarea>
                </div>


            </div>
        </div>


        <x-safweb.pagesections.pagecontrol>
            <button type="submit" class="py-1.5 mx-2 px-6 bg-ctrl-green text-ctrl-dark hover:bg-green-300">{{ __('edit') }}<i class="fa fa-save ml-2"></i></button>
            <a onclick="return confirm('Diesen Satz wirklich löschen?')" href="/admin/users/group/{{ $group->id }}/delete" role="button" class="py-1.5 mx-2 px-6 bg-ctrl-red text-white hover:bg-red-400">löschen<i class="fa fa-trash ml-2"></i></a>
        </x-safweb.pagesections.pagecontrol>

    </form>
</x-layout>
