<x-layout>
    <x-core::pagesections.edit_view :model="$model" action="{{ route('admin.group.update', $model->id) }}">
        <x-safweb.forms.input autofocus tabindex="1" name="name" value="{{ old('name', $model->name) }}" label="{{ __('Group') }}" size="40" />
        <x-safweb.forms.input tabindex="2" name="description" value="{{ old('description', $model->description) }}" label="{{ __('Description') }}" size="40" />

        <div class="p-1 bg-ctrl-tbl-blue">
            <label for="permission">
                Permission
            </label>
        </div>
        <div class="px-2">
            <select
                name="permissions[]"
                tabindex="3"
                multiple
                size="10"
                class = "_w-full mt-1 p-1 text-sm font-mono border-[1px] border-blue-900 bg-white"
            >
                    @foreach ($permissions as $permission)
                        <option class="_w-full" value="{{ $permission->id }}" {{ $model->hasPermission($permission->token) ? 'selected' : '' }}>
                            {{ $permission->token }} - {{ $permission->name }}
                        </option>
                    @endforeach
            </select>
        </div>
        <div class="p-1">&nbsp;</div>

    </x-core::pagesections.edit_view>
</x-layout>
