<?php

return [
    'name' => 'Admin',
    'title' => 'Admin',
    'subtitle' => 'SAFweb Administration',
    'namespace' => 'App\Modules\Admin',
    'version' => '1.0.0',
    'navigation' => [
        'meta' => [
            'name' => 'Admin',
            'desc' => 'Systemadministration',
            'link' => '/admin',
            'permission' => true,
            'icon' => 'fa-screwdriver'
        ],
        'functions' => [
            'users' => [
                'meta' => [
                    'name' => 'Anwender und Gruppen',
                    'desc' => 'Anwender, Rollen, Gruppen und Rechte verwalten',
                    'link' => '/admin/users',
                    'permission' => true,
                    'icon' => 'fa-users'
                ],
                'functions' => [
                    'user' => [
                        'meta' => [
                            'name' => 'Anwender bearbeiten',
                            'desc' => 'Anwender anlegen, bearbeiten, freigeben, sperren und löschen',
                            'link' => '/admin/users/user',
                            'permission' => true,
                            'icon' => 'fa-user'
                        ]
                    ],
                    'rollen' => [
                        'meta' => [
                            'name' => 'Rollen bearbeiten',
                            'desc' => 'Rollen anlegen, bearbeiten, und löschen. Gruppen zuordnen.',
                            'link' => '/admin/users/roles',
                            'permission' => true,
                            'icon' => 'fa-users'
                        ]
                    ],
                    'gruppen' => [
                        'meta' => [
                            'name' => 'Gruppen bearbeiten',
                            'desc' => 'Gruppen anlegen, bearbeiten, und löschen. Rechte zuordnen.',
                            'link' => '/admin/users/groups',
                            'permission' => true,
                            'icon' => 'fa-users'
                        ]
                    ],
                    'rechte' => [
                        'meta' => [
                            'name' => 'Rechte bearbeiten',
                            'desc' => 'Rechte anlegen, bearbeiten, und löschen.',
                            'link' => '/admin/users/permissions',
                            'permission' => true,
                            'icon' => 'fa-users'
                        ]
                    ]
                ],
            ],
            'konfiguration' => [
                'meta' => [
                    'name' => 'Konfiguration',
                    'desc' => 'Systemeinstellungen',
                    'link' => '/admin/config',
                    'permission' => true,
                    'icon' => 'fa-check-square'
                ],
                'functions' => [],
            ],
            'system-info' => [
                'meta' => [
                    'name' => 'System-Info',
                    'desc' => 'Informationen über das System',
                    'link' => '/admin/info',
                    'permission' => true,
                    'icon' => 'fa-info'
                ],
                'functions' => [
                    'sysc' => [
                        'meta' => [
                            'name' => 'System Core Info',
                            'desc' => 'Informationen über das System',
                            'link' => '/admin/sysc',
                            'permission' => true,
                            'icon' => 'fa-info'
                        ]
                    ]
                ],
            ],
            'sql-support' => [
                'meta' => [
                    'name' => 'SQL Support',
                    'desc' => 'SQL Abfragen',
                    'link' => '/admin/sqlsupport',
                    'permission' => true,
                    'icon' => 'fa-terminal'
                ],
                'functions' => [
                    'orasql' => [
                        'meta' => [
                            'name' => 'Ora-SQL',
                            'desc' => 'Oracle SQL Editor',
                            'link' => '/admin/orasql-support',
                            'permission' => true,
                            'icon' => 'fa-terminal'
                        ]
                    ]
                ],
            ],
            'db-admin' => [
                'meta' => [
                    'name' => 'DB-Admin',
                    'desc' => 'System-Datenbankadministration',
                    'link' => '/admin/database',
                    'permission' => true,
                    'icon' => 'fa-database'
                ],
                'functions' => [],
            ],
            'saf1_import' => [
                'meta' => [
                    'name' => 'safWEB1 Import',
                    'desc' => 'Importhelper from safWEB1 Installations',
                    'link' => '/admin/safweb_importer',
                    'permission' => true,
                    'icon' => 'fa-download'
                ],
                'functions' => [
                    'users' => [
                        'meta' => [
                            'name' => 'Userimport',
                            'desc' => 'Importiert alle Anwender aus safWEB1',
                            'link' => '/admin/safweb1_userimport',
                            'permission' => true,
                            'icon' => 'fa-file-import'
                        ],
                    ]
                ],
            ],
        ],
    ],
    'models' => [
        'Group' => ['modul' => 'admin.users'],
        'Permission' => ['modul' => 'admin.users'],
        'Role' => ['modul' => 'admin.users'],
        'User' => ['modul' => 'admin.users']
    ]
];
