<?php

namespace App\modules\Admin\Controllers;

use App\Http\Controllers\Controller;
use App\modules\Core\Services\OraApiService;
use Illuminate\Http\Request;

class SqlSupportContoller extends Controller
{
    public function orasqlsupport()
    {
        return view('admin::sqlsupport.orasqlsupport');
    }

    public function sqlExec(Request $request,OraApiService $apiService)
    {
        $request->validate([
            'database' => 'required|string',
            'username' => 'required|string',
            'username' => 'required|string',
            'sql' => 'required|string',
            'limit' => 'nullable|integer',
            'linearlist' => 'nullable|integer',
            'showsql' => 'nullable|integer',
        ]);

        $response = $apiService->dbAdminSqlExec($request);
        $data = $response['data'] ?? [];

        $executed_sql = '';
        if ($request->get('showsql')) {
            $executed_sql = (trim($response['params']['executed_sql'])) ?? '';
        }
        return view('admin::sqlsupport.sqlexec', compact('data','executed_sql'));
    }
}
