<?php

namespace App\modules\Admin\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\modules\Core\Services\SafwebLegacyService;
use Illuminate\Support\Facades\Validator;

class SafwebLegacyController extends Controller
{
    public function user_import()
    {
        //$allOldUser = \DB::connection('safweb1_sys')->select('select * from users');
        $dbConnector= 'safweb1_sys_soyer';
        $safwebLegacy = new SafwebLegacyService();
        $allOldUser = $safwebLegacy->getAllOldUser($dbConnector, 'info@soyer.de');
        foreach ($allOldUser as $user) {
            $user->exists = User::where('login', $user->login)->exists();
        }
        $tableDef = [
            'header' => [
                'uid' => 'UID',
                'login' => 'Login',
                'email' => 'Email',
                'state' => 'Status',
                'exists' => 'in SAFweb2',
            ],
            'columns' => [
                'uid' => ['type' => 'string'],
                'login' => ['type' => 'string'],
                'email' => ['type' => 'string'],
                'state' => ['type' => 'boolean'],
                'exists' => ['type' => 'boolean'],
            ],
            'meta' => [
                'keyname' => 'uid'
            ]
        ];
        return view('admin::legacy.import_user', ['data' => $allOldUser, 'tableDef' => $tableDef]);
    }

    public function user_import_exec()
    {
        $dbConnector= 'safweb1_sys_soyer';
        $safwebLegacy = new SafwebLegacyService();
        $importedUser = $safwebLegacy->importAllOldUser($dbConnector, 'info@soyer.de');

        return redirect()->route('admin.user');
    }
}
