<?php

namespace App\modules\Admin\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Group;
use App\Models\Role;
use App\modules\Core\Services\ListTableDefinitionService;
use Illuminate\Http\Request;

class RoleAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(ListTableDefinitionService $listTable)
    {
        $data = Role::all();
        $tableDef = $listTable->getDefinitionForModel(Role::class);
        return view(
            'admin::roles.index', compact('tableDef', 'data')
        );
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $groups = Group::all();
        return view('admin::roles.create', ['groups' => $groups]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $parameter = $request->validate([
            'name' => 'required|string',
            'description' => 'nullable|string'
        ]);

        $role = Role::create($parameter);
        $role->groups()->sync($request->groups);
        return redirect()->route('admin.roles');
    }

    /**
     * Display the specified resource.
     */
    public function show(Role $role)
    {
        $groups = $role->groups; //Group::all();
        $users = $role->users;
        return view('admin::roles.show', ['model' => $role, 'groups' => $groups, 'users' => $users]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Role $role)
    {
        $groups = Group::all();
        return view('admin::roles.edit', ['model' => $role, 'groups' => $groups]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Role $role)
    {
        $parameter = $request->validate([
            'name' => 'required|string',
            'description' => 'nullable|string'
        ]);

        $role->update($parameter);
        $role->groups()->sync($request->groups);

        return redirect()->route('admin.roles');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Role $role)
    {
        $role->delete();
        return redirect()->route('admin.roles');
    }
}
