<?php

namespace App\modules\Admin\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Permission;
use App\modules\Core\Services\FilesystemService;
use App\modules\Core\Services\ListTableDefinitionService;
use App\modules\Core\Traits\ModuleHelperTrait;
use Illuminate\Http\Request;

class PermissionAdminController extends Controller
{
    use ModuleHelperTrait;

    /**
     * Display a listing of the resource.
     */
    public function index(ListTableDefinitionService $listTable)
    {
        $data = Permission::all();
        $tableDef = $listTable->getDefinitionForModel(Permission::class);
//        dd($tableDef, $data);
        return view('admin::permissions.index', compact('tableDef', 'data'));
    }


    public function scanmenus(ListTableDefinitionService $listTable)
    {
        $scanPermissions = $this->getPermissions();
        $data = Permission::all();
        $tableDef = $listTable->getDefinitionForModel(Permission::class);

        $modulPermissions = [];
        foreach ($scanPermissions as $permission) {
            list($token, $name, $desc) = explode("|", $permission);
            if ($data->contains('token', $token)) {
                $modulPermissions[] = [
                    'value' => $permission,
                    'token' => $token,
                    'name' => $name,
                    'desc' => $desc,
                    'stored' => true,
                ];
            } else {
                $modulPermissions[] = [
                    'value' => $permission,
                    'token' => $token,
                    'name' => $name,
                    'desc' => $desc,
                    'stored' => false
                ];
            }
        }
        return view(
            'admin::permissions.scanmenus',
            ['modulPermissions' => $modulPermissions, 'data' => $data, 'tableDef' => $tableDef]
        );
    }

    public function scanmodels(FilesystemService $filesystem, ListTableDefinitionService $listTable)
    {
        $models = $filesystem->scanForModels();
        $data = Permission::all();
        $tableDef = $listTable->getDefinitionForModel(Permission::class);
        $registeredModels = $this->getAllModels();

        $modelPermissions = [];
        foreach ($models as $model) {
            $register = isset($registeredModels[$model]) ? 'model.'.$registeredModels[$model]['modul'] : '';
            $token = $register.'.'. \Str::snake($model);
            $stored = (
                $data->contains('token', $token.'.create') ||
                $data->contains('token', $token.'.read') ||
                $data->contains('token', $token.'.update') ||
                $data->contains('token', $token.'.delete')
            ) ? true : false;

            $modelPermissions[] = [
                'value' => $token, //$register.'.'. \Str::snake($model),
                'name' => $model,
                'stored' => $stored,
                'registered' => $register,
            ];
        }

        $tblHeader = [
            ['label' => ''],
            ['label' => 'Model'],
            ['label' => 'Modul'],
        ];
        return view(
            'admin::permissions.scanmodels',
            ['modelPermissions' => $modelPermissions, 'data' => $data, 'tableDef' => $tableDef, 'tblHeader' => $tblHeader]
        );
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin::permissions.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $parameter = $request->validate([
            'name' => 'required|string',
            'token' => 'required|string',
            'description' => 'nullable|string'
        ]);

        Permission::create($parameter);
        return redirect()->route('admin.permissions');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    /**
     * Add new Permissions, scanned from Modules Config (files))
     */
    public function addScanned(Request $request)
    {
        if ($request->get('scanpermission') == null) {
            return redirect()->route('admin.permissions');
        }

        foreach ($request->get('scanpermission') as $idx => $permission) {
            list($token, $name, $desc) = explode("|", $permission);
            Permission::create([
                'token' => $token,
                'name' => $name,
                'description' => $desc,
                'created_at' => now(),
            ]);
        }
        return redirect()->route('admin.permissions');
    }

    public function addScannedModels(Request $request)
    {
        if ($request->get('scanmodelpermission') == null) {
            return redirect()->route('admin.permissions');
        }

        foreach ($request->get('scanmodelpermission') as $idx => $permission) {
            $parts = explode(".", $permission);
            $modelName = ucfirst(\Str::camel(array_pop($parts)));
            $modelString = array_shift($parts);
            $desc = implode(".", $parts);
            Permission::create(['name' => $modelName.' Create', 'token' => $permission.'.create', 'description' => $desc, 'created_at' => now(),]);
            Permission::create(['name' => $modelName.' Read', 'token' => $permission.'.read', 'description' => $desc, 'created_at' => now(),]);
            Permission::create(['name' => $modelName.' Update', 'token' => $permission.'.update', 'description' => $desc, 'created_at' => now(),]);
            Permission::create(['name' => $modelName.' Delete', 'token' => $permission.'.delete', 'description' => $desc, 'created_at' => now(),]);
        }
        return redirect()->route('admin.permissions');
    }
}
