<?php

namespace App\modules\Admin\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Group;
use App\Models\Permission;
use App\modules\Core\Services\ListTableDefinitionService;
use Illuminate\Http\Request;

class GroupAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(ListTableDefinitionService $listTable)
    {
        $data = Group::all();
        $tableDef = $listTable->getDefinitionForModel(Group::class);
        return view('admin::groups.index', compact('tableDef', 'data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin::groups.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $parameter = $request->validate([
            'name' => 'required|string',
            'description' => 'nullable|string'
        ]);

        $group = Group::create($parameter);
        $group->permissions()->sync($request->permissions);
        return redirect()->route('admin.groups');
    }

    /**
     * Display the specified resource.
     */
    public function show(Group $group)
    {
        $permissions = $group->permissions->sortBy('token');
        $permissionString = '';
        foreach ($permissions as $permission) {
            $permissionString .= $permission->token.' - '.$permission->name . "\n";
        }
        return view('admin::groups.show', ['group' => $group, 'permissions' => $permissions, 'permissionString' => $permissionString]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Group $group)
    {
        $permissions = Permission::all();
        return view('admin::groups.edit', ['model' => $group, 'permissions' => $permissions]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Group $group)
    {
        $parameter = $request->validate([
            'name' => 'required|string',
            'description' => 'nullable|string'
        ]);

        $group->update($parameter);
        $group->permissions()->sync($request->permissions);
        return redirect()->route('admin.groups');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Group $group)
    {
        $group->delete();
        return redirect()->route('admin.groups');
    }
}
