<?php

namespace App\Providers;

use App\Policies\ModelPolicy;
use App\Policies\NavigationPolicy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Context;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Gate::define('visitlink', [NavigationPolicy::class, 'visitlink']);
        Gate::guessPolicyNamesUsing(function (string $modelClass) {
            return ModelPolicy::class;
        });

        // needed to display the Modulename and Link in TopNav
        $modulName = request()->segment(1);
        $modulNameSegment = request()->segment(2);
        if ($modulName == 'hellosafwebai' || $modulName == 'askai') {
            $modulName = 'SAFwebAI';
        }
        Context::add('modulName', $modulName);
        Context::add('modulNameSegment', $modulNameSegment);
        view()->share('modulName', ucfirst($modulName));
        view()->share('modulLink', request()->segment(1));
    }
}
