<?php

namespace App\Policies;

use App\Models\Permission;
use App\Models\User;
use App\modules\Core\Traits\AdminTrait;


class NavigationPolicy
{
    use AdminTrait;

    /**
     * Create a new policy instance.
     */
    public function __construct()
    {
        //
    }

    public function visitlink(User $user, $linkEntryFromModul)
    {
        $permission = $this->linkToPermission($linkEntryFromModul);
        if ($this->userIsMasterAdmin($user) || $user->hasPermission($permission)) {
            return true;
        }
        return false;
    }



    protected function linkToPermission($linkEntryFromModul)
    {
        $link = trim($linkEntryFromModul, '/');
        $permission = str_replace('/', '.', $link);
        return $permission;
    }
}
