<?php

namespace App\Policies;

use App\Models\User;
use App\modules\Core\Traits\AdminTrait;
use Illuminate\Database\Eloquent\Model;

class ModelPolicy
{
    use AdminTrait;

    /**
     * Create a new policy instance.
     */
    public function __construct()
    {
        //
    }

    public function update(User $user, Model $model)
    {
        $modelToken = $this->modelToPermissionToken($model).'.update';
        if ($this->userIsMasterAdmin($user) || $user->permissions()->contains($modelToken)) {
            return true;
        }
        return false;
    }

    public function create(User $user, Model $model)
    {
        $modelToken = $this->modelToPermissionToken($model).'.create';
        if ($this->userIsMasterAdmin($user) || $user->permissions()->contains($modelToken)) {
            return true;
        }
        return false;
    }

    public function show(User $user, Model $model)
    {
        $modelToken = $this->modelToPermissionToken($model).'.show';
        if ($this->userIsMasterAdmin($user) || $user->permissions()->contains($modelToken)) {
            return true;
        }
        return false;
    }

    public function edit(User $user, Model $model)
    {
        $modelToken = $this->modelToPermissionToken($model).'.edit';
        if ($this->userIsMasterAdmin($user) || $user->permissions()->contains($modelToken)) {
            return true;
        }
        return false;
    }


    protected function modelToPermissionToken(Model $model)
    {
        $namespace = get_class($model);
        $namespaceParts = explode('\\', $namespace);
        $modelName = \Str::snake(array_pop($namespaceParts));
        $_ModelsPart = array_pop($namespaceParts);
        $modulName = strtolower(array_pop($namespaceParts));

        if(strtolower($modulName) == 'app') {
            $modulName = 'admin.users';
        }

        $token = 'model.'.$modulName.'.'.$modelName;
        return $token;
    }

}
