<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Collection;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'login',
        'name',
        'email',
        'email_verified_at',
        'password',
        'status',
        'pwd_expired',
        'login_counter',
        'lastlogin',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * User specific Permission
     */
    public function userPermissions()
    {
        return $this->belongsToMany(Permission::class, 'permission_user', 'user_id', 'permission_id');
    }

    public function hasUserPermission($permissionToken)
    {
        return $this->UserPermissions->contains($permissionToken);
    }


    public function roles()
    {
        return $this->belongsToMany(Role::class, 'role_user', 'user_id', 'role_id');
    }

    public function hasRole($role)
    {
        return $this->roles->contains($role);
    }

    public function groups()
    {
        $roles = $this->roles;
        $groups = new Collection();
        foreach ($roles as $role) {
            foreach ($role->groups as $group) {
                $groups->add($group);
            }
        }
        return $groups;
    }


    public function permissions()
    {
        $groups = $this->groups();
        $permissions = [];
        foreach ($groups as $group) {
            foreach ($group->permissions as $permission) {
                $permissions[] = $permission->token;
            }
        }
        return collect($permissions);
    }

    public function hasPermission($permissionToken)
    {
        return $this->permissions()->contains($permissionToken);
    }

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public static function indexColumnSettings(): array
    {
        return [
            'header' => [
                'id' => 'ID',
                'login' => 'Login',
                'name' => 'Name',
                'email' => 'Email',
                'status' => 'aktiv',
                'created_at' => 'angelegt',
            ],
            'columns' => [
                'id' => ['type' => 'number'],
                'login' => ['type' => 'string'],
                'name' => ['type' => 'string', 'fnedit' => '/admin/users/user'],
                'email' => ['type' => 'string'],
                'status' => ['type' => 'boolean'],
                'created_at' => ['type' => 'date'],
            ],
        ];
    }
}
