<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable = ['name', 'description'];

    function groups(): BelongsToMany
    {
        return $this->belongsToMany(Group::class);
    }

    public function hasGroup($group): bool
    {
        return $this->groups->contains($group);
    }

    function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class);
    }
}
