<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable = ['name', 'description'];


    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(Role::class, 'group_role', 'group_id', 'role_id');
    }

    public function permissions(): BelongsToMany
    {
        return $this->belongsToMany(Permission::class, 'group_permission', 'group_id', 'permission_id');
    }

    public function hasPermission($permissionToken)
    {
        return $this->permissions->contains('token', $permissionToken);
    }

    public function hasRole($role)
    {
        return $this->roles->contains($role);
    }


    public function columnLabels()
    {
        return [
            'id' => __('ID'),
            'name' => __('Name'),
            'description' => __('Description'),
        ];
    }

    public function columnTypes()
    {
        return [
            'id' => ['type' => 'number'],
            'name' => ['type' => 'string', 'fnedit' => '/admin/users/group'],
            'description' => ['type' => 'string'],
        ];
    }
}
